#pragma once
#include <iostream>
#include <vector>
#include <set>
#include <array>
#include <unordered_map>
#include <iomanip>

class Node 
{
public:
    size_t NodeId;
    std::array<double, 3> coordinates;
    bool isVertex = false;

    Node() = default;
    Node(int, const std::array<double, 3>&, bool);
    friend std::istream& operator>>(std::istream&, Node&);
    friend std::ostream& operator<<(std::ostream&, const Node&);
    friend std::ostream& operator<<(std::ostream&, const std::vector<Node>&);
};

class FiniteElement 
{
public:
    size_t FEId;
    size_t MaterialId;
    std::vector<size_t> FiniteElementIdList;

    FiniteElement() = default;
    FiniteElement(const FiniteElement&) = default;
    friend std::istream& operator>>(std::istream&, FiniteElement&);
    friend std::ostream& operator<<(std::ostream&, const FiniteElement&);
    friend std::ostream& operator<<(std::ostream&, const std::vector<FiniteElement>&);
};

class BoundaryFiniteElement : public FiniteElement
{
public:
    size_t BFEId;
    size_t boundaryId;
    //std::vector<size_t> BoundaryFiniteElementIdList;

    friend std::istream& operator>>(std::istream&, BoundaryFiniteElement&);
    friend std::ostream& operator<<(std::ostream&, const BoundaryFiniteElement&);
    friend std::ostream& operator<<(std::ostream&, const std::vector<BoundaryFiniteElement>&);
};

class Edge 
{
public:
    std::pair<size_t, size_t> nodePair;
    size_t centerNode;

    void setCenter(size_t);
    Edge(size_t, size_t);
    bool operator==(const Edge&) const;
};

